/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class LootCrateWrapper
implements ITooltipCallback<ItemStack> {
    public final LootCrate crate;
    public final Component name;
    public final ItemStack itemStack;
    public final List<ItemStack> items;
    public final List<WeightedReward> rewards;
    public final List<List<ItemStack>> itemLists;

    public LootCrateWrapper(LootCrate c) {
        this.crate = c;
        this.name = this.crate.table.getTitle();
        this.itemStack = this.crate.createStack();
        this.items = new ArrayList<ItemStack>(c.table.rewards.size());
        this.rewards = new ArrayList<WeightedReward>(c.table.rewards);
        this.rewards.sort(null);
        for (WeightedReward reward : this.rewards) {
            ItemStack stack;
            Object object = reward.reward.getIngredient();
            ItemStack itemStack = stack = object instanceof ItemStack ? (ItemStack)object : ItemStack.f_41583_;
            if (!stack.m_41619_()) {
                this.items.add(stack.m_41777_());
                continue;
            }
            if (reward.reward.getIcon() instanceof ItemIcon) {
                stack = ((ItemIcon)reward.reward.getIcon()).getStack().m_41777_();
                stack.m_41714_(reward.reward.getTitle());
                this.items.add(stack);
                continue;
            }
            stack = new ItemStack((ItemLike)Items.f_42487_);
            stack.m_41714_(reward.reward.getTitle());
            stack.m_41700_("icon", (Tag)StringTag.m_129297_((String)reward.reward.getIcon().toString()));
            this.items.add(stack);
        }
        if (this.items.size() <= 50) {
            this.itemLists = new ArrayList<List<ItemStack>>(this.items.size());
            for (ItemStack stack : this.items) {
                this.itemLists.add(Collections.singletonList(stack));
            }
        } else {
            int i;
            this.itemLists = new ArrayList<List<ItemStack>>(50);
            for (i = 0; i < 50; ++i) {
                this.itemLists.add(new ArrayList());
            }
            for (i = 0; i < this.items.size(); ++i) {
                this.itemLists.get(i % 50).add(this.items.get(i));
            }
        }
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)this.itemStack);
        ingredients.setOutputLists(VanillaTypes.ITEM, this.itemLists);
    }

    private String chance(String type, int w, int t) {
        String s = I18n.m_118938_((String)("ftbquests.loot.entitytype." + type), (Object[])new Object[0]) + ": " + WeightedReward.chanceString(w, t);
        if (w > 0) {
            s = s + " (1 in " + StringUtils.formatDouble00((double)(1.0 / ((double)w / (double)t))) + ")";
        }
        return s;
    }

    public void drawInfo(PoseStack matrixStack, Minecraft mc, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        mc.f_91062_.m_92763_(matrixStack, (Component)this.crate.table.getMutableTitle().m_130940_(ChatFormatting.UNDERLINE), 36.0f, 0.0f, -14540254);
        int total = ClientQuestFile.INSTANCE.lootCrateNoDrop.passive;
        for (RewardTable table : ClientQuestFile.INSTANCE.rewardTables) {
            if (table.lootCrate == null) continue;
            total += table.lootCrate.drops.passive;
        }
        mc.f_91062_.m_92883_(matrixStack, this.chance("passive", this.crate.drops.passive, total), 36.0f, 10.0f, -14540254);
        total = ClientQuestFile.INSTANCE.lootCrateNoDrop.monster;
        for (RewardTable table : ClientQuestFile.INSTANCE.rewardTables) {
            if (table.lootCrate == null) continue;
            total += table.lootCrate.drops.monster;
        }
        mc.f_91062_.m_92883_(matrixStack, this.chance("monster", this.crate.drops.monster, total), 36.0f, 19.0f, -14540254);
        total = ClientQuestFile.INSTANCE.lootCrateNoDrop.boss;
        for (RewardTable table : ClientQuestFile.INSTANCE.rewardTables) {
            if (table.lootCrate == null) continue;
            total += table.lootCrate.drops.boss;
        }
        mc.f_91062_.m_92883_(matrixStack, this.chance("boss", this.crate.drops.boss, total), 36.0f, 28.0f, -14540254);
    }

    public void onTooltip(int slot, boolean input, ItemStack ingredient, List<Component> tooltip) {
        if (slot > 0 && slot - 1 < this.items.size()) {
            for (int i = 0; i < this.items.size(); ++i) {
                if (this.items.get(i) != ingredient) continue;
                tooltip.add((Component)new TranslatableComponent("jei.ftbquests.lootcrates.chance", new Object[]{ChatFormatting.GOLD + WeightedReward.chanceString(this.rewards.get((int)i).weight, this.crate.table.getTotalWeight(true))}).m_130940_(ChatFormatting.GRAY));
                return;
            }
        }
    }
}

